using TMPro;
using Unity.Collections;
using UnityEngine;
using static DataStore;

public class FixedStringDataBinding : MonoBehaviour
{
    private TextMeshPro tmp;
    public string fieldName;
    private AnimData animData;
    private FixedString128Bytes lastString;
    
    private void Start()
    {
        animData = DataStore.GetInstance().GetAnimData(fieldName);
        tmp = GetComponent<TextMeshPro>();
        FixedString128Bytes s = DataStore.GetInstance().GetFixedString128(animData);
        ApplyText(s);
    }
    
    private void Update()
    {
        FixedString128Bytes s = DataStore.GetInstance().GetFixedString128(animData);
        if (!s.Equals(lastString))
            ApplyText(s);
    }
    
    private void ApplyText(FixedString128Bytes s)
    {
        lastString = s;
        tmp.text = s.ToString();
    }
}